#include <Wire.h>
#define Chip 0x50    //Address of 24C08 eeprom chip
#include <LiquidCrystal.h>
LiquidCrystal lcd(10, 11, 4,5,6,7);// LiquidCrystal(rs, enable, d0, d1, d2, d3, d4, d5, d6, d7);
//=========================================================================
void setup() 
{  
    //--------------------
    Wire.begin();
    lcd.begin(20, 4);   
    lcd.setCursor(0, 0); lcd.print("====================");      
    lcd.setCursor(0, 1); lcd.print("    Arduino uno     "); 
    lcd.setCursor(0, 2); lcd.print("  Development kit   ");  
    lcd.setCursor(0, 3); lcd.print("===================="); 
    delay(1500);
    lcd.setCursor(0, 1); lcd.print(" Serial EEPROM Test "); 
    lcd.setCursor(0, 2); lcd.print("                    ");  
    delay(2000);
    if ( TestChip(Chip) == 0  )
    {
    lcd.setCursor(0, 2); lcd.print("      Test ok       ");  
    }
    else
    {
    lcd.setCursor(0, 2); lcd.print("    Test Failed     ");
    }       
}
//=========================================================================
void loop()
{
}
//============================================================
unsigned char TestChip(unsigned int DeviceAddress)
{
    word Address;
    byte T_Value;    
    byte R_Value;
    byte Data = 0x55;
    lcd.setCursor(0, 2); lcd.print("  Chip(  ) Testing  ");

    for (Address = 0; Address < 100 ; Address++)
    {
        lcd.setCursor(7,2); lcd.print(Address);
        T_Value = ReadEEPROM(DeviceAddress, Address);
        WriteEEPROM(DeviceAddress, Address, Data);
        R_Value = ReadEEPROM(DeviceAddress, Address);
        if ( R_Value != Data ) { return 1; }
        WriteEEPROM(DeviceAddress, Address, T_Value);
    }
    return 0;
}  

void WriteEEPROM(int deviceaddress, unsigned int eeaddress, byte data) 
{
    Wire.beginTransmission(deviceaddress);
    Wire.write((int)(eeaddress)); 
    Wire.write(data);
    Wire.endTransmission();
    delay(10);
}
 
byte ReadEEPROM(int deviceaddress, unsigned int eeaddress ) 
{
    byte rdata = 0xFF;
    Wire.beginTransmission(deviceaddress);
    Wire.write((int)(eeaddress));   
    Wire.endTransmission();
    Wire.requestFrom(deviceaddress,1);
    if (Wire.available()) rdata = Wire.read();
    return rdata;
}  
